local t = GetString
local ct = {}
ct.mod_id = nil
ct.main_open = true
ct.main_visible = true
ct.logMsg = ""
ct.log_lines = {}
ct.test_message = ""
ct.yes_selected = false
ct.no_selected = false
ct.maybe_selected = false
ct.result_modes = {
	new_id = "new_id",
	success = "success",
	error = "error",
	message = "message",
}
ct.errors = {
	setting_commands = {
		error_code = 1001,
		message = "Error Setting Commands."
	},
	missing_fields = {
		error_code = 1002,
		message = "Please provide an author, command function, mod name, and description."
	},
	mod_name_spaces = {
		error_code = 1003,
		message = "Mod name cannot contain spaces."
	},
	cmdFunc_not_function = {
		error_code = 1004,
		message = "[cmdFunc] must be a function."
	},
	duplicate_mod = {
		error_code = 1005,
		message = "Mod already registered. Please use a different author / name combination."
	},
	mod_not_found = {
		error_code = 1006,
		message = "Mod not found."
	},
	id_not_supplied = {
		error_code = 1007,
		message = "ID not supplied."
	},
	mod_not_allow_posting = {
		error_code = 1008,
		message = "Mod does not allow posting."
	},
	message_not_supplied = {
		error_code = 1009,
		message = "Please supply a message."
	},
	no_registered_clients = {
		error_code = 1010,
		message = "The user has not registered any communication clients."
	},
}

ct.AddLogLine = function(line)
    if type(line) == "table" then
        line = ct.TableToString(line)
    end

    line = string.format("[%s] %s", os.date("%H:%M:%S"), line)

    table.insert(ct.log_lines, 1, line)

    if #ct.log_lines > 100 then
        table.remove(ct.log_lines, 1)
    end

    ct.logMsg = table.concat(ct.log_lines, "\n")
end

ct.log = function(line)
    ct.AddLogLine(line)
end

ct.RegMod = function()
    if CherryConnect then
        local result = CherryConnect.Register("cherry", ct.IncomingMessages, "chattest",
            "This mod tests the features of the cherryTelegram connection.")


        if result.mode == "error" then
            ct.log("Error: " .. result.message)
        else
            ct.log("Registered mod: " .. result.message)
            ct.mod_id = result.message
        end
    end
end

ct.UnRegMod = function()
    if ct.mod_id then
        local result = CherryConnect.Unregister(ct.mod_id)

        if result.mode == ct.result_modes.error then
            ct.log("Error: " .. result.message)
        else
            ct.log("Success: " .. result.message)
        end

        ct.mod_id = nil
    else
        ct.log("Not registered.")
    end
end

ct.Init = function()
    -- you could register your mod here as well
    -- chat_test.RegMod()
end
RegisterEventHandler("Module.Initalize", ct.Init, "chat_test.Init")

ct.OpenAddon = function()
    ct.main_open = true
    ct.main_visible = true
end

ct.TableToString = function(tbl, indent)
    if not indent then indent = '' end
    local str = '{\n'
    for k, v in pairs(tbl) do
        str = str .. indent .. '  [' .. tostring(k) .. '] = '
        if type(v) == 'table' then
            str = str .. ct.TableToString(v, indent .. '  ') .. ',\n'
        else
            str = str .. tostring(v) .. ',\n'
        end
    end
    return str .. indent .. '}'
end

ct.IncomingMessages = function(result)
    if result then
        if result.mode == ct.result_modes.error then
            ct.log("Error: " .. result.message)
        elseif result.mode == ct.result_modes.new_id then
            ct.log("New ID: " .. result.message)
        elseif result.mode == ct.result_modes.success then
            ct.log("Success: " .. result.message)
        elseif result.mode == ct.result_modes.message then
            if not result.message.telegram_msg then
                local sendResult = CherryConnect.Message(ct.mod_id,
                    "Hi! I am designed to help you write your own integration to cherryTelegram. Enter my command with a message and I'll echo it to you.")

                if sendResult.error then
                    ct.log("Error: " .. sendResult.message)
                elseif sendResult.success then
                    ct.log("Success: " .. sendResult.message)
                end
            else
                CherryConnect.Message(ct.mod_id,
                    "Here's your message back: " .. result.message.telegram_msg)
            end

            if result.message then
                if result.message.cmd then
                    ct.log("cmd: " .. result.message.cmd)
                end
                if result.message.telegram_msg then
                    ct.log("Telegram Message: " .. result.message.telegram_msg)
                end
            end
        else
            ct.log("Unknown Result: " .. ct.TableToString(result))
        end
    end
end

ct.SendMessage = function()
    if #ct.test_message > 0 then
        local result = CherryConnect.Message(ct.mod_id, ct.test_message)

        if result.mode == ct.result_modes.error then
            ct.log("Error: " .. result.message)
        else
            ct.log("Success: " .. result.message)
        end
    else
        ct.log("Please enter a message to send.")
    end
end

ct.BuildOptions = function()
    local options = {}

    if ct.yes_selected then
        table.insert(options, "Yes")
    end
    if ct.no_selected then
        table.insert(options, "No")
    end
    if ct.maybe_selected then
        table.insert(options, "Maybe")
    end

    return options
end

ct.SendOptionsMessage = function()
    if #ct.test_message > 0 then
        local options = ct.BuildOptions()

        if #options < 2 then
            ct.log("Please select at least two option.")
        else
            --A callback function is used here so that the code can be encapsulated. If the callback function is not provided then the response will be in the incoming messages function
            local result = CherryConnect.MessageOptions(ct.mod_id, options, ct.test_message,
                function(option, callback_id)
                    ct.log("User Picked: " .. option)
                    CherryConnect.MessageResponse(ct.mod_id, callback_id, "Thank you for picking: " .. option)
                end)

            if result.mode == ct.result_modes.error then
                ct.log("Error: " .. result.message)
            else
                ct.log("Success: " .. result.message)
            end
        end
    else
        ct.log("Please enter a message to send.")
    end
end

ct.SendComplexOptionsMessage = function()
    CherryConnect.MessageOptions(ct.mod_id, { "Ok.", "Not so good" }, "How you doing, buddy?",
        function(option, callback_id)
            --Any time you give the user the option to provide a response you have to provide a callback that tells telegram that the response has been received. You can give a message or not.
            CherryConnect.MessageResponse(ct.mod_id, callback_id, "")

            if option == "Ok." then
                CherryConnect.Message(ct.mod_id, "Thats great to hear!")
            else
                CherryConnect.MessageOptions(ct.mod_id,
                    { "Play some FFXIV.", "Nothing Really...", "Anything other than this." },
                    "Well that's too bad. What would you rather be doing?",
                    function(option, callback_id)
                        CherryConnect.MessageResponse(ct.mod_id, callback_id )

                        if option == "Play some FFXIV." then
                            CherryConnect.Message(ct.mod_id, "Well get to it!")
                        elseif option == "Nothing Really..." then
                            CherryConnect.Message(ct.mod_id, "I can't help you then")
                        elseif option == "Anything other than this." then
                            CherryConnect.Message(ct.mod_id, "Well then do that instead of talking to me.")
                        end

                    end)
            end
        end)
end

ct.Draw = function(event, ticks)
    if (ct.main_open) then
        GUI:SetNextWindowSize(500, 400, GUI.SetCond_FirstUseEver)
        ct.main_visible, ct.main_open = GUI:Begin("Chat mod tester", ct.main_open)
        if (ct.main_visible) then
            GUI:PushItemWidth(-1)
            GUI:BulletText(t("Log"))

            GUI:Separator()

            GUI:BeginChild("##scrolling_log", -1, GUI:GetWindowHeight() - 160, true)
            GUI:TextWrapped(ct.logMsg)
            GUI:EndChild()

            GUI:Text("Message: ")
            GUI:SameLine()

            ct.test_message, _ = GUI:InputText("##SendMessageID", ct.test_message,
                GUI.InputTextFlags_EnterReturnsTrue and GUI.InputTextFlags_AllowTabInput)

            GUI:Text("Options: ")
            GUI:SameLine()
            ct.yes_selected, _ = GUI:Checkbox("Yes##ctYesSelected", ct.yes_selected)
            GUI:SameLine()
            ct.no_selected, _ = GUI:Checkbox("No##ctYesSelected", ct.no_selected)
            GUI:SameLine()
            ct.maybe_selected, _ = GUI:Checkbox("Maybe##ctYesSelected", ct.maybe_selected)

            GUI:Separator()

            if GUI:Button("Register") then
                ct.RegMod()
            end
            GUI:SameLine()

            if GUI:Button("Unregister") then
                ct.UnRegMod()
            end
            GUI:SameLine()

            if GUI:Button("Send Message") then
                ct.SendMessage()
            end
            GUI:SameLine()
            if GUI:Button("Send Options Message") then
                ct.SendOptionsMessage()
            end
            if GUI:Button("Send Complex Options Message") then
                ct.SendComplexOptionsMessage()
            end

            GUI:PopItemWidth()
        end

        GUI:End()
    end
end

ct.log(
    [[
This mod is designed to test the features of the cherryTelegram connection. The following steps will help you test the features of the connection:

1. Register the mod
2. Enter a message in the message box
3. Click the "Send Message" button
4. Select at least two options to test the options message
5. Click the "Send Options Message" button
6. Click the "Send Complex Message" button to see an example of complex message sending and receiving]])

RegisterEventHandler("Gameloop.Draw", ct.Draw, "chat_test.Draw")