-- We have 2 different 'frameworks' on which the bot logic runs. ( You can write / add your own one if you are that desperate :P )
-- 1. 'Cause & Effect' :  https://github.com/MINIONBOTS/FFXIVMinion/wiki/AI-Framework  is very detailed explained here, but in short : you add a bunch of 'cause'-functions aka 'if xxx ' which each have a different priority. Each pulse all causes are evaluated and for the first one which evaluates to 'true' the corresponding 'effect' aka 'then yyy' is executed. 
-- 1. Behavior Tree: http://wiki.mmominion.com/doku.php?id=behaviortree  , This is only used by our gw2 bot, but it could also be used by ffxiv. However, ffxiv does not use it because it was too much of a rewrite back then when we added this 'v1.0' of  the BTree. Right now, we are having a v2.0 nearly done and future produkts will be using it.

-- This example below shows the 'Cause & effect' one and makes use of a bunch of pre-defined functions that your task need to have, in order to integrate it into the "main menu" / Botmode.
-- You are completely free to write your own addon with your own 'main window' or whatever comes to your mind. 

newaddon = inheritsFrom(ml_task)	-- inherits basic funcs / values that each addon/botmode needs. 

-- Called when a new task of this is created
function newaddon.Create()
    local newinst = inheritsFrom(newaddon)    
    --ml_task members
    newinst.valid = true
    newinst.completed = false
    newinst.subtask = nil
    newinst.auxiliary = false
    newinst.process_elements = {}
    newinst.overwatch_elements = {}    
   
    return newinst
end

-- One Cause&Effect pair
c_gotopostest = inheritsFrom( ml_cause )
e_gotopostest = inheritsFrom( ml_effect )
-- The Evaluate function must ALWAYS return true or false
function c_gotopostest:evaluate()
	local mapID = tonumber(c_gotopostest.mapid)
	if (Player.localmapid == mapID) then
		local ppos = Player.pos
		local pos = {}
		pos.x = tonumber(c_gotopostest.x)
		pos.y = tonumber(c_gotopostest.y)
		pos.z = tonumber(c_gotopostest.z)
		
		local dist = Distance3D(ppos.x, ppos.y, ppos.z, pos.x, pos.y, pos.z)
		if (dist > 2) then
			c_gotopostest.pos = pos
			return true
		end
	end
	return false
end
-- If the Evaluate function returned true, this function is being executed:
function e_gotopostest:execute()
	-- Creating a new moveto task ( which is also a cause&effect defined in another .lua file, but can be globally used by everyone )
	local newTask = ffxiv_task_movetopos.Create()
	newTask.pos = c_gotopostest.pos
	ml_task_hub:CurrentTask():AddSubTask(newTask) -- Adds this new task as subtask to whatever other task is currently running 	
end


-- Registering all the cause & Effect functions with a specific priority ( ich which order they are being evaluated ), higher prio means evaluated first
function newaddon:Init()
	local ke_startMapTest = ml_element:create( "GoToPosTest", c_gotopostest, e_gotopostest, 20 )
    self:add(ke_startMapTest, self.process_elements)
	
	-- You can add more C&Es to your task here which are then all evaluated 
	--local ke_startMoveTest = ml_element:create( "NeedsToFart", c_gotonpctest, e_gotonpctest, 15 )
   -- self:add(ke_startMoveTest, self.process_elements)	
end

-- Init UI element variables
function newaddon:UIInit()
	-- if you need to show text in the UI, best is to use GetString("my text here") , this allows us to let users translate everything you write into their localized language ( there is a system in place for that )
	c_gotopostest.mapid = (Player and Player.localmapid) or 0
	c_gotopostest.x = 0
	c_gotopostest.y = 0
	c_gotopostest.z = 0
end

-- Helper to draw UI elements in the 'Main Menu Window'
function newaddon:Draw()
	
	GUI:BeginChild("##header-status")
	c_gotopostest.mapid = GUI:InputText("MapID",c_gotopostest.mapid)
	c_gotopostest.x = GUI:InputText("X",c_gotopostest.x)
	c_gotopostest.y = GUI:InputText("Y",c_gotopostest.y)
	c_gotopostest.z = GUI:InputText("Z",c_gotopostest.z)
	
	
	GUI:Separator()
	local FullWidth = GUI:GetContentRegionAvail()
	if (GUI:Button("Get Current Pos",FullWidth,20)) then
		newaddon.GetCurrentPosition()
	end
	GUI:EndChild()
end

function newaddon.GetCurrentPosition()
	local mapid = Player.localmapid
	local pos = Player.pos
	
	c_gotopostest.x = pos.x
	c_gotopostest.y = pos.y
	c_gotopostest.z = pos.z
	c_gotopostest.mapid = mapid
end

-- Finally, adding our Task to show up in  the Main Window as "Botmode" .. as explained above, that is just one of many options you have. http://wiki.mmominion.com/doku.php?id=dailies_-_stormblood the bottox team made their own superb dynamic window for example. 
ffxivminion.AddMode("New Addon Test", newaddon)